﻿const string justificationSectionAlias = "ExJustification";
const string commentAlias = "Comment";

const string fileCategoryName = "Финансовое обоснование";

var dCard = await dialog.GetCardObjectAsync();
var mCard = await this.GetCardObjectAsync();

dCard.ID = Guid.NewGuid();

// Перенос комментария к финансовому обоснованию из карточки СЗ в карточку диалога.
dCard.Sections[justificationSectionAlias].Fields[commentAlias] = mCard.Sections[justificationSectionAlias].Fields[commentAlias];

// Подготовка и копирование файлов из карточки СЗ в карточку диалога.
mCard.Files.RemoveAll(i => !string.Equals(i.CategoryCaption, fileCategoryName, StringComparison.Ordinal));

var result = await CardHelper.CopyFilesAsync(
	mCard,
	dCard,
	this.Context.Container,
	cancellationToken: this.Context.CancellationToken);
this.ValidationResult.Add(result);

if(result.HasErrors)
{
	return; 
}

var dCardFiles = dCard.Files;

// Сохранение информации о внешнем источнике контента файла.
var fileIDContentSources = new Dictionary<string, object>(dCardFiles.Count, StringComparer.Ordinal);
foreach(var dCardFile in dCardFiles)
{
	fileIDContentSources.Add(dCardFile.RowID.ToString("N"), dCardFile.ExternalSource.FileID.ToString("N"));
}

this.Process.FileIDContentSources = fileIDContentSources;